<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/Episode.php";
include_once "models/Apikey.php";

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty",
    );
    echo json_encode($response);
    exit;
}

$contentType = $_SERVER["CONTENT_TYPE"] ?? "";
if(strpos($contentType, "application/json") !== false){
    $data = json_decode(file_get_contents("php://input"));
    
    $_POST = $data ?? [];
} 

$title = $_POST["title"] ?? "";
$link = $_POST["link"] ?? "";
$movieid = $_POST["movieid"] ?? "";
$moviename = $_POST["moviename"] ?? "";
$date = $_POST["date"] ?? "";

if(empty($title) || empty($link) || empty($movieid) || empty($moviename) || empty($date)){
    $response = array(
        "success" => false,
        "message" => "All fields are required",
    );

    echo json_encode($response);
    exit;
}

$episodes = new Episode($db);
$episodes->title = $title;
$episodes->link = $link;
$episodes->movieid = $movieid;
$episodes->moviename = $moviename;
$episodes->date = $date;

$result = $episodes->createEpisodes();

if(!$result){
    $response = array(
        "success" => false,
        "message" => "Something went wrong",
    );

    echo json_encode($response);
    exit;
}

$response = array(
    "success" => true,
    "message" => "Episode added successfully",
);

echo json_encode($response);

?>