<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/User.php";
include_once "models/Apikey.php";

if($_SERVER["REQUEST_METHOD"] != "GET"){
    $response = array(
        "success" => false,
        "message" => "Unauthorized request"
    );
    echo json_encode($response);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty",
    );
    echo json_encode($response);
    exit;
}


$user = new User($db);

$contentType = $_SERVER["CONTENT_TYPE"] ?? "";
if(strpos($contentType, "application/json") !== false){
    $data = json_decode(file_get_contents("php://input"));
    
    $_POST = $data ?? [];
} 

$phone = $_GET["phone"] ?? "";

if(empty($phone)){
    http_response_code(401);

    $response = array(
        "success" => false,
        "message" => "Phone number is required"
    );

    echo json_encode($response);
    exit;
}

$numLength = $user->countNumber($phone);

if(!$numLength["success"]){
    echo json_encode($numLength);
    exit;
}

$result = $user->getUser($phone);

if(!$result["success"]){
    echo json_encode($result);
    exit;
}

echo json_encode($result);



?>





