<?php

class Category{
    public $conn;
    public $table = "categories";

    public function __construct($db){
        $this->conn = $db;
    }

    public function getCategory(){
        $query = "SELECT * FROM " . $this->table;
        $category = $this->conn->prepare($query);
        $category->execute();

        $allCategories = $category->fetchAll(PDO::FETCH_ASSOC);

        $data = [];

        foreach($allCategories as $allCategory){
            $data [] = $allCategory;
        }

        if(count($data) > 0){
            return array(
                "success" => true,
                "message" => "Category available",
                "data" => $data,
            );
        }

        return array(
            "success" => false,
            "message" => "Something went wrong",
        );
    }
}

?>