<?php
 
class movie{
    //db connection
    private $conn;
    //tables
    private $table = "movies";
    private $episode_table = "episodes";

    //movie properties
    public $id;
    public $title;
    public $category;
    public $image;
    public $description;
    public $date;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function createMovies(){
        $checks = "SELECT * FROM " .$this->table . " WHERE title = :title LIMIT 1";
        $this->title = htmlspecialchars(strip_tags($this->title));
        
        $movie = $this->conn->prepare($checks);
        $movie->bindParam(":title", $this->title);
        $movie->execute();

        $numRow = $movie->rowCount();

        if($numRow > 0){
            return array(
                "success" => false,
                "message" => "Movie is available"
            );
        }



        $query = "INSERT INTO " . $this->table . " (title, category, image, description, date) 
        VALUES (:title, :category, :image, :description, :date)";

        $insert = $this->conn->prepare($query);

        $this->title = strip_tags($this->title);
        $this->category = strip_tags($this->category);
        $this->image = strip_tags($this->image);
        $this->description = strip_tags($this->description);
        $this->date = strip_tags($this->date);

        $insert->bindParam(":title", $this->title, PDO::PARAM_STR);
        $insert->bindParam(":category", $this->category, PDO::PARAM_STR);
        $insert->bindParam(":image", $this->image, PDO::PARAM_STR);
        $insert->bindParam(":description", $this->description, PDO::PARAM_STR);
        $insert->bindParam(":date", $this->date, PDO::PARAM_STR);

        if($insert->execute()){
            return array(
                "success" => true,
                "message" => "movie insert successful"
            );
        }

        return array(
            "success" => false,
            "message" => "Movie insert failure"
        );

    }

    public function allMovie($page){

        $perpage = 10;

        $page = max(1, (int) $page);
        $start = ($page - 1) * $perpage;

        $query = "SELECT id, title, category, image, description FROM " . $this->table . 
        " ORDER BY id DESC LIMIT :start, :page";

        $movies = $this->conn->prepare($query);
        $movies->bindValue(":start", (int) $start, PDO::PARAM_INT);
        $movies->bindValue(":page", (int) $perpage, PDO::PARAM_INT);

        $movies->execute();

       

        $allMovies = $movies->fetchAll(PDO::FETCH_ASSOC);

        $post = [];

        foreach($allMovies as $allMovie){
            $post[] = $allMovie;
        }

        if(count($post) > 0){
            return array(
                "success" => true,
                "message" => "successful fetch",
                "data" => $post
            );
        }
        
        return array(
            "success" => false,
            "message" => "No post found"
        );
            
       
    }

    
}





