<?php

class User{

    private $conn;
    private $table = "users";

    public $id;
    public $device_id;
    public $phone;
    public $status;
    public $day;
    public $date;

    public function __construct($db) {
        $this->conn = $db;
    }


    public function signup(){
        $checks = "SELECT phone FROM " . $this->table . " WHERE phone = :phone";
        $user = $this->conn->prepare($checks);
        $user->bindParam(":phone", $this->phone);
        $user->execute();

        $numRow = $user->rowCount();

        if($numRow > 0){
            return array(
                "success" => false,
                "message" => "User available please login"
            );
        }

        $query = "INSERT INTO " . $this->table . "(device_id, phone, status, day, date) 
         VALUES (:device_id, :phone, :status, :day, :date)";

        $insert = $this->conn->prepare($query);

        $this->phone = (int) $this->phone;
        $this->day = (int) $this->day;
        $this->status = "unpaid";

        $insert->bindParam(":device_id", $this->device_id, PDO::PARAM_STR);
        $insert->bindParam(":phone", $this->phone, PDO::PARAM_INT);
        $insert->bindParam(":status", $this->status, PDO::PARAM_STR);
        $insert->bindParam(":day", $this->day, PDO::PARAM_INT);
        $insert->bindParam(":date", $this->date, PDO::PARAM_STR);

        if($insert->execute()){
            return array(
                "success" => true,
                "message" => "Signup successful"
            );
        }

        return array(
            "success" => false,
            "message" => "Failed to signup"
        );


    }

    public function login(){
        $query = "SELECT id, device_id, phone, status, day, date FROM " . $this->table . " WHERE phone = :phone LIMIT 1";

        $stmt = $this->conn->prepare($query);

        $this->phone = (int) $this->phone;

        $stmt->bindParam(":phone", $this->phone, PDO::PARAM_INT);

        $stmt->execute();

        $numRow = $stmt->rowCount();

        if($numRow > 0){
            $row = $stmt->fetch(PDO::FETCH_ASSOC);

            if($this->phone == $row["phone"] && $this->device_id == $row["device_id"]){
                $post = [];
                $res = array(
                        "id" => $row["id"],
                        "device_id" => $row["device_id"],
                        "phone" => $row["phone"],
                        "status" => $row["status"],
                        "day" => $row["day"],
                        "date" => $row["date"]
                    );
                    $post [] = $res;
            return array(
                    "success" => true,
                    "message" => "Login successful",
                    "data" => $post
                );
                
            }else{
                return array(
                    "success" => false,
                    "message" => "Phone number already used"
                );
            }
        }

        return array(
            "success" => false,
            "message" => "Signup"
        );

    }

    public function getUser($phone){
        $query = "SELECT id, device_id, phone, status, day, date FROM " . $this->table . " WHERE phone = :phone LIMIT 1";
        $user = $this->conn->prepare($query);
        $user->bindParam(":phone", $phone, PDO::PARAM_INT);
        $user->execute();

        $numRow = $user->rowCount();

        if($numRow > 0){
            $row = $user->fetch(PDO::FETCH_ASSOC);

            return array(
                "success"=> true,
                "message" => "Fetch successful",
                "data" => array(
                    "id" => $row["id"],
                    "device_id" => $row["device_id"],
                    "phone" => $row["phone"],
                    "status" => $row["status"],
                    "day" => $row["day"],
                    "date" => $row["date"]
                )
            );
        }

        return array(
            "success" => false,
            "message" => "User not found"
        );
    }

    public function verifyUser($phone, $day, $status){
        $query = "SELECT phone FROM " . $this->table . " WHERE phone = :phone LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":phone", $phone, PDO::PARAM_INT);
        $stmt->execute();

        $numRow = $stmt->rowCount();

        if($numRow  > 0){
            
            $query2 = "UPDATE " . $this->table . " SET status = :status, day = :day WHERE phone = :phone";
            $insert = $this->conn->prepare($query2);

            $phone = (int) $phone;
            $day = (int) $day;
            
            $insert->bindParam(":status", $status, PDO::PARAM_STR);
            $insert->bindParam(":day", $day, PDO::PARAM_INT);
            $insert->bindParam(":phone", $phone, PDO::PARAM_INT);

            if($insert->execute()){
                return array(
                    "success" => true,
                    "message" => "Verify successful"
                );
            }

            return array(
                "success" => false,
                "message" => "Something went wrong"
            );

        }else{
            return array(
                "success" => false,
                "message" => "Phone number not available"
            );
        }


    }

    public function countNumber($phone){
        if(strlen($phone) !== 10){
            return array(
                "success" => false,
                "message" => "Invalid phone number",
            );
        }

        return array(
            "success" => true,
        );
    }


}

