<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/User.php";
include_once "models/Apikey.php";

if($_SERVER["REQUEST_METHOD"] != "POST"){
    $response = array(
        "success" => false,
        "message" => "Unauthorized request method"
    );

    echo json_encode($response);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);
$user = new User($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty",
    );
    echo json_encode($response);
    exit;
}

$phone = $_POST["phone"] ?? "";
$day = $_POST["day"] ?? "";
$status = $_POST["status"] ?? "";

if(empty($phone) || $day === ""){
    $response = array(
        "success" => false,
        "message" => "All fields are required"
    );
    
    echo json_encode($response);
    exit;
}

$numLength = $user->countNumber($phone);

if(!$numLength["success"]){
    echo json_encode($numLength);
    exit;
}


if(strlen($phone) != 10){
    
    echo json_encode($response);
    exit;
}





$result = $user->verifyUser($phone, $day, $status);

if(!$result["success"]){
    echo json_encode($result);
    exit;
}

echo json_encode($result);












?>